/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.toh;

import de.polarnetworks.ft.FTObject;
import de.polarnetworks.ft.calibration.Calibration;
import de.polarnetworks.ft.toh.Lift;
import de.polarnetworks.ft.toh.Rotation;
import de.polarnetworks.ft.util.FTConfig;
import ftcomputing.robo.JavaFish;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.commons.logging.LogFactory;

public class Tower
extends FTObject {
    private static Tower instance = null;
    private static final byte LEFT = 0;
    private static final byte MIDDlE = 1;
    private static final byte RIGHT = 2;
    private Lift lift;
    private Rotation rotation;
    private boolean grabber;

    public Tower(int handle, JavaFish ft) {
        super(handle, ft);
    }

    public static Tower getInstance(int iHandle, JavaFish ft) {
        if (instance == null) {
            instance = new Tower(iHandle, ft);
            String calibrationPath = FTConfig.getInstance().getProperty("toh.calibration.file");
            try {
                instance.setCalibration(new Calibration(new FileInputStream(calibrationPath)));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("No calibrationfile found. Please calibrate your model first.");
            }
        }
        return instance;
    }

    public Lift getLift() {
        if (this.lift == null) {
            this.lift = new Lift(this.iHandle, this.ft, this.calibration);
        }
        return this.lift;
    }

    public Rotation getRotation() {
        if (this.rotation == null) {
            this.rotation = new Rotation(this.iHandle, this.ft, this.calibration);
        }
        return this.rotation;
    }

    public void putFromMiddleToRight() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().toMiddle(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().maxRight(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public void putFromRightToMiddle() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().maxRight(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().toMiddle(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public void putFromMiddleToLeft() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().toMiddle(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().maxLeft(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public void putFromLeftToMiddle() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().maxLeft(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().toMiddle(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public void putFromLeftToRight() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().maxLeft(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().maxRight(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public void putFromRightToLeft() {
        this.getLift().relax(false);
        JavaFish.sleep(500);
        this.getRotation().maxRight(false);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(false);
        JavaFish.sleep(500);
        this.getLift().relax(true);
        JavaFish.sleep(500);
        this.getRotation().maxLeft(true);
        JavaFish.sleep(500);
        this.getLift().moveDownToLimt(true);
        JavaFish.sleep(500);
        this.getLift().relax(false);
    }

    public boolean isGrabber() {
        return this.grabber;
    }

    public void setGrabber(boolean grabber) {
        this.grabber = grabber;
    }

    public void solveProblem() {
        this.moveDiscs(FTConfig.getInstance().getIntProperty("toh.discs"), (short)0, (short)1, (short)2);
    }

    private void moveDiscs(int discs, short fromStack, short tmp, short toStack) {
        if (discs == 1) {
            this.move(fromStack, toStack);
            LogFactory.getLog(Tower.class).info("Moving one disc from " + fromStack + " to " + toStack);
        } else {
            int n = discs - 1;
            this.moveDiscs(n, fromStack, toStack, tmp);
            this.move(fromStack, toStack);
            LogFactory.getLog(Tower.class).info("Moving disc from " + fromStack + " to " + toStack);
            this.moveDiscs(n, tmp, fromStack, toStack);
        }
    }

    private void move(short fromStack, short toStack) {
        block0 : switch (fromStack) {
            case 0: {
                switch (toStack) {
                    case 1: {
                        this.putFromLeftToMiddle();
                        break;
                    }
                    case 2: {
                        this.putFromLeftToRight();
                    }
                }
                break;
            }
            case 1: {
                switch (toStack) {
                    case 0: {
                        this.putFromMiddleToLeft();
                        break;
                    }
                    case 2: {
                        this.putFromMiddleToRight();
                    }
                }
                break;
            }
            case 2: {
                switch (toStack) {
                    case 1: {
                        this.putFromRightToMiddle();
                        break block0;
                    }
                    case 0: {
                        this.putFromRightToLeft();
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        JavaFish ft = new JavaFish();
        int iHandle = ft.jrOpenInterfaceUSB(0, 0);
        Tower tower = Tower.getInstance(iHandle, ft);
        tower.solveProblem();
    }
}

