/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.toh;

import de.polarnetworks.ft.calibration.Calibration;
import de.polarnetworks.ft.toh.TOHObject;
import ftcomputing.robo.JavaFish;
import org.apache.commons.logging.LogFactory;

public class Rotation
extends TOHObject {
    private int maxLeft = 570;
    private int maxRight = 290;
    private int middle = 400;
    private int targetZone = 40;

    public Rotation(int handle, JavaFish ft, Calibration calibration) {
        super(handle, ft, calibration);
        if (calibration != null) {
            this.maxLeft = calibration.getValueForChannelAndTag(Calibration.InputChannel.EY, "maxLeft");
            this.middle = calibration.getValueForChannelAndTag(Calibration.InputChannel.EY, "middle");
            this.maxRight = calibration.getValueForChannelAndTag(Calibration.InputChannel.EY, "maxRight");
        }
    }

    public void maxLeft(boolean withGrab) {
        LogFactory.getLog(Rotation.class).debug("Moving to max. left position. Starting at: " + this.ft.jrGetAnalog(this.iHandle, 2));
        this.checkGrab(withGrab);
        int state = this.ft.jrGetMotors(this.iHandle) + 2;
        if (this.ft.jrGetAnalog(this.iHandle, 2) > this.maxLeft) {
            int pos;
            do {
                if ((pos = this.ft.jrGetAnalog(this.iHandle, 2)) - this.maxLeft <= this.targetZone) {
                    state = this.ft.jrSetMotors(this.iHandle, state - 2);
                    JavaFish.sleep(200);
                    state = this.ft.jrSetMotors(this.iHandle, state + 2);
                    JavaFish.sleep(20);
                }
                this.ft.jrSetMotors(this.iHandle, state);
            } while (pos >= this.maxLeft);
        } else {
            int pos;
            state = this.ft.jrGetMotors(this.iHandle) + 1;
            do {
                if (this.maxLeft - (pos = this.ft.jrGetAnalog(this.iHandle, 2)) <= this.targetZone) {
                    state = this.ft.jrSetMotors(this.iHandle, state - 1);
                    JavaFish.sleep(200);
                    state = this.ft.jrSetMotors(this.iHandle, state + 1);
                    JavaFish.sleep(20);
                }
                this.ft.jrSetMotors(this.iHandle, state);
            } while (pos <= this.maxLeft);
        }
        this.stopAllRegardingGrabber(withGrab);
    }

    public void maxRight(boolean withGrab) {
        int pos;
        LogFactory.getLog(Rotation.class).debug("Moving to max. right position. Starting at: " + this.ft.jrGetAnalog(this.iHandle, 2));
        this.checkGrab(withGrab);
        int state = this.ft.jrGetMotors(this.iHandle) + 2;
        do {
            if ((pos = this.ft.jrGetAnalog(this.iHandle, 2)) - this.maxRight < this.targetZone) {
                this.ft.jrSetMotors(this.iHandle, state - 2);
                state = this.ft.jrGetMotors(this.iHandle);
                JavaFish.sleep(200);
                this.ft.jrSetMotors(this.iHandle, state + 2);
                state = this.ft.jrGetMotors(this.iHandle);
                JavaFish.sleep(20);
            }
            this.ft.jrSetMotors(this.iHandle, state);
        } while (pos >= this.maxRight);
        this.stopAllRegardingGrabber(withGrab);
    }

    public void toMiddle(boolean withGrab) {
        LogFactory.getLog(Rotation.class).debug("Moving to middle position. Starting at: " + this.ft.jrGetAnalog(this.iHandle, 2));
        this.checkGrab(withGrab);
        int state = this.ft.jrGetMotors(this.iHandle) + 2;
        int pos = this.ft.jrGetAnalog(this.iHandle, 2);
        if (pos > this.middle) {
            do {
                if ((pos = this.ft.jrGetAnalog(this.iHandle, 2)) - this.middle < this.targetZone) {
                    this.ft.jrSetMotors(this.iHandle, state - 2);
                    state = this.ft.jrGetMotors(this.iHandle);
                    JavaFish.sleep(200);
                    this.ft.jrSetMotors(this.iHandle, state + 2);
                    state = this.ft.jrGetMotors(this.iHandle);
                    JavaFish.sleep(20);
                    continue;
                }
                this.ft.jrSetMotors(this.iHandle, state);
            } while (pos > this.middle);
        } else {
            state = this.ft.jrGetMotors(this.iHandle) + 1;
            do {
                if (this.middle - (pos = this.ft.jrGetAnalog(this.iHandle, 2)) < this.targetZone) {
                    this.ft.jrSetMotors(this.iHandle, state - 1);
                    state = this.ft.jrGetMotors(this.iHandle);
                    JavaFish.sleep(200);
                    this.ft.jrSetMotors(this.iHandle, state + 1);
                    state = this.ft.jrGetMotors(this.iHandle);
                    JavaFish.sleep(20);
                    continue;
                }
                this.ft.jrSetMotors(this.iHandle, state);
            } while (pos < this.middle);
        }
        this.stopAllRegardingGrabber(withGrab);
    }
}

