/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.toh;

import de.polarnetworks.ft.calibration.Calibration;
import de.polarnetworks.ft.toh.TOHObject;
import de.polarnetworks.ft.toh.Tower;
import ftcomputing.robo.JavaFish;
import org.apache.commons.logging.LogFactory;

public class Lift
extends TOHObject {
    private int relaxPosition = 460;

    public Lift(int handle, JavaFish ft) {
        this(handle, ft, null);
    }

    public Lift(int handle, JavaFish ft, Calibration calibration) {
        super(handle, ft, calibration);
        if (calibration != null) {
            this.relaxPosition = calibration.getValueForChannelAndTag(Calibration.InputChannel.EX, "relaxPosition");
        }
    }

    public void moveDownToLimt(boolean withGrab) {
        Tower.getInstance(this.iHandle, this.ft).setGrabber(withGrab);
        this.checkGrab(withGrab);
        int state = this.ft.jrGetMotors(this.iHandle) + 4;
        do {
            this.ft.jrSetMotors(this.iHandle, state);
        } while (this.ft.jrGetInput(this.iHandle, 1) != 1);
        this.stopAllRegardingGrabber(withGrab);
    }

    public void moveUpToLimt(boolean withGrab) {
        Tower.getInstance(this.iHandle, this.ft).setGrabber(withGrab);
        this.checkGrab(withGrab);
        int state = this.ft.jrGetMotors(this.iHandle) + 8;
        while (this.ft.jrGetInput(this.iHandle, 2) != this.calibration.getValueForChannelAndTag(Calibration.InputChannel.E2, "maxUp")) {
            this.ft.jrSetMotors(this.iHandle, state);
        }
        state = this.ft.jrGetMotors(this.iHandle) + 4;
        while (this.ft.jrGetInput(this.iHandle, 2) == this.calibration.getValueForChannelAndTag(Calibration.InputChannel.E2, "maxUp")) {
            this.ft.jrSetMotors(this.iHandle, state);
        }
        this.stopAllRegardingGrabber(withGrab);
    }

    public void moveUpByAmount(int amount, boolean withGrab) {
        Tower.getInstance(this.iHandle, this.ft).setGrabber(withGrab);
        this.checkGrab(withGrab);
        int start = this.ft.jrGetAnalog(this.iHandle, 1);
        int target = start + amount;
        LogFactory.getLog(Lift.class).info("Moving up, starting by: " + start);
        int state = this.ft.jrGetMotors(this.iHandle) + 8;
        while (this.ft.jrGetInput(this.iHandle, 2) != this.calibration.getValueForChannelAndTag(Calibration.InputChannel.E2, "maxUp") && this.ft.jrGetAnalog(this.iHandle, 1) <= target) {
            this.ft.jrSetMotors(this.iHandle, state);
        }
        this.stopAllRegardingGrabber(withGrab);
    }

    public void moveDownByAmount(int amount, boolean withGrab) {
        Tower.getInstance(this.iHandle, this.ft).setGrabber(withGrab);
        this.checkGrab(withGrab);
        int start = this.ft.jrGetAnalog(this.iHandle, 1);
        LogFactory.getLog(Lift.class).info("Moving down, starting by: " + start);
        int target = start - amount;
        int state = this.ft.jrGetMotors(this.iHandle) + 4;
        while (this.ft.jrGetInput(this.iHandle, 1) != this.calibration.getValueForChannelAndTag(Calibration.InputChannel.E1, "maxDown") && this.ft.jrGetAnalog(this.iHandle, 1) >= target) {
            this.ft.jrSetMotors(this.iHandle, state);
        }
        this.stopAllRegardingGrabber(withGrab);
    }

    public void relax(boolean withGrab) {
        Tower.getInstance(this.iHandle, this.ft).setGrabber(withGrab);
        this.checkGrab(withGrab);
        int currentPosition = this.ft.jrGetAnalog(this.iHandle, 1);
        if (currentPosition <= this.relaxPosition) {
            this.moveUpByAmount(this.relaxPosition - currentPosition, withGrab);
        } else if (currentPosition >= this.relaxPosition) {
            this.moveDownByAmount(currentPosition - this.relaxPosition, withGrab);
        }
        this.stopAllRegardingGrabber(withGrab);
    }
}

