/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.plotter.predefinedPlots;

import de.polarnetworks.ft.plotter.PlotterInterface;
import de.polarnetworks.ft.plotter.predefinedPlots.Plottable;
import de.polarnetworks.ft.plotter.predefinedPlots.PredefinedPlot;

public class Snowflake
extends Plottable
implements PredefinedPlot {
    int level = 6;

    public Snowflake() {
    }

    public Snowflake(PlotterInterface plotter) {
        super(plotter);
    }

    @Override
    public void plot() {
        this.getPlotter().initHome();
        double x1 = 50.0;
        double y1 = 360.0;
        double angle = -1.0471975511965976;
        int i = 0;
        while (i < 3) {
            this.drawCurve(this.getPlotter(), x1, y1, angle, 380.0, this.level);
            x1 += 380.0 * Math.cos(angle);
            y1 += 380.0 * Math.sin(angle);
            angle += 2.0943951023931953;
            ++i;
        }
        this.getPlotter().initHome();
    }

    private void drawCurve(PlotterInterface plotter, double x1, double y1, double angle1, double sideLength, int level) {
        if (level > 1) {
            this.drawCurve(plotter, x1, y1, angle1, sideLength /= 3.0, --level);
            double x2 = x1 + sideLength * Math.cos(angle1);
            double y2 = y1 + sideLength * Math.sin(angle1);
            double angle2 = angle1 - 1.0471975511965976;
            this.drawCurve(plotter, x2, y2, angle2, sideLength, level);
            double x3 = x2 + sideLength * Math.cos(angle2);
            double y3 = y2 + sideLength * Math.sin(angle2);
            double angle3 = angle1 + 1.0471975511965976;
            this.drawCurve(plotter, x3, y3, angle3, sideLength, level);
            double x4 = x3 + sideLength * Math.cos(angle3);
            double y4 = y3 + sideLength * Math.sin(angle3);
            this.drawCurve(plotter, x4, y4, angle1, sideLength, level);
        } else {
            plotter.drawLine((int)x1, (int)y1, (int)(x1 + sideLength * Math.cos(angle1)), (int)(y1 + sideLength * Math.sin(angle1)), true);
        }
    }

    @Override
    public String getIdentifier() {
        return "snowflake";
    }
}

