/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.plotter.predefinedPlots;

import de.polarnetworks.ft.plotter.PlotterInterface;
import de.polarnetworks.ft.plotter.predefinedPlots.Plottable;
import de.polarnetworks.ft.plotter.predefinedPlots.PredefinedPlot;

public class Sierpinski
extends Plottable
implements PredefinedPlot {
    private double x1 = 10.0;
    private double y1 = 10.0;
    private double x3 = 270.0;
    private double y3 = 460.0;
    private double x2 = 530.0;
    private double y2 = 10.0;
    private int depth = 6;

    public Sierpinski() {
    }

    public Sierpinski(PlotterInterface plotter) {
        super(plotter);
    }

    @Override
    protected PlotterInterface getPlotter() {
        return this.plotter;
    }

    protected double getX1() {
        return this.x1;
    }

    protected double getY1() {
        return this.y1;
    }

    protected double getX2() {
        return this.x2;
    }

    protected double getY2() {
        return this.y2;
    }

    protected double getX3() {
        return this.x3;
    }

    protected double getY3() {
        return this.y3;
    }

    protected int getDepth() {
        return this.depth;
    }

    @Override
    public void plot() {
        this.getPlotter().initHome();
        int[] xCoords = new int[]{(int)this.getX1(), (int)this.getX2(), (int)this.getX3()};
        int[] yCoords = new int[]{(int)this.getY1(), (int)this.getY2(), (int)this.getY3()};
        this.getPlotter().drawPolygon(xCoords, yCoords, 3);
        this.calculateAndDrawTraingle(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getX3(), this.getY3(), this.getDepth());
        this.getPlotter().initHome();
    }

    private void calculateAndDrawTraingle(double x1, double y1, double x2, double y2, double x3, double y3, int level) {
        if (level == 0) {
            return;
        }
        --level;
        int[] xCoords = new int[]{(int)Math.round(x3), (int)Math.round((x3 + x2) / 2.0), (int)Math.round((x1 + x3) / 2.0)};
        int[] yCoords = new int[]{(int)Math.round(y2), (int)Math.round((y3 + y2) / 2.0), (int)Math.round((y3 + y1) / 2.0)};
        this.getPlotter().drawPolygon(xCoords, yCoords, 3);
        double firstAx = x1;
        double firstAy = y1;
        double firstBx = x3;
        double firstBy = y2;
        double firstCx = (x1 + x3) / 2.0;
        double firstCy = (y3 + y1) / 2.0;
        this.calculateAndDrawTraingle(firstAx, firstAy, firstBx, firstBy, firstCx, firstCy, level);
        double secondAx = x3;
        double secondAy = y2;
        double secondBx = x2;
        double secondBy = y2;
        double secondCx = (x3 + x2) / 2.0;
        double secondCy = (y3 + y1) / 2.0;
        this.calculateAndDrawTraingle(secondAx, secondAy, secondBx, secondBy, secondCx, secondCy, level);
        double thirdAx = (x1 + x3) / 2.0;
        double thirdAy = (y3 + y1) / 2.0;
        double thirdBx = (x3 + x2) / 2.0;
        double thirdBy = (y3 + y1) / 2.0;
        double thirdCx = x3;
        double thirdCy = y3;
        this.calculateAndDrawTraingle(thirdAx, thirdAy, thirdBx, thirdBy, thirdCx, thirdCy, level);
    }

    @Override
    public String getIdentifier() {
        return "sierpinksi_triangle";
    }
}

