/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.plotter.predefinedPlots;

import de.polarnetworks.ft.plotter.PlotterInterface;
import de.polarnetworks.ft.plotter.predefinedPlots.Plottable;
import de.polarnetworks.ft.plotter.predefinedPlots.PredefinedPlot;
import java.awt.Point;

public class Lindenmayer2
extends Plottable
implements PredefinedPlot {
    Point a;
    Point b;
    int lengthF = 4;
    double direction;
    double rotation = 37.0;

    @Override
    public void plot() {
        this.a = new Point(350, 30);
        this.direction = 90.0;
        this.turtleGraphic(this.getPlotter(), "T", 7);
    }

    public void turtleGraphic(PlotterInterface plotter, String instruction, int depth) {
        if (depth == 0) {
            return;
        }
        --depth;
        Point aMark = new Point(0, 0);
        double directionMark = 0.0;
        int i = 0;
        while (i < instruction.length()) {
            char c = instruction.charAt(i);
            if (c == 'T') {
                this.turtleGraphic(this.getPlotter(), "R-[T]++[++L]R[--L]+[T]--T", depth);
            } else if (c == 'R') {
                this.turtleGraphic(this.getPlotter(), "F[++L][--L]F", depth);
            } else if (c == 'L') {
                this.turtleGraphic(this.getPlotter(), "[+FX-FX-FX+|+FX-FX-FX|+FXFX]", depth);
            } else if (c == 'F') {
                if (i + 1 < instruction.length() && instruction.charAt(i + 1) == 'X') {
                    this.turtleGraphic(this.getPlotter(), "FX", depth);
                } else {
                    this.turtleGraphic(this.getPlotter(), "FF", depth);
                }
                if (depth == 0) {
                    double rad = Math.PI / 180 * this.direction;
                    int p = (int)((double)this.lengthF * Math.cos(rad));
                    int q = (int)((double)this.lengthF * Math.sin(rad));
                    this.b = new Point(this.a.x + p, this.a.y + q);
                    if (i + 1 < instruction.length()) {
                        instruction.charAt(i + 1);
                    }
                    this.getPlotter().drawLine(this.a.x, this.a.y, this.b.x, this.b.y);
                    this.a = this.b;
                }
            } else if (c == '+') {
                this.direction += this.rotation;
            } else if (c == '-') {
                this.direction -= this.rotation;
            } else if (c == '|') {
                this.direction += 180.0;
            } else if (c == '[') {
                aMark = this.a;
                directionMark = this.direction;
            } else if (c == ']') {
                this.a = aMark;
                this.direction = directionMark;
            }
            ++i;
        }
    }

    @Override
    public String getIdentifier() {
        return "lindenmayer2";
    }
}

