/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.plotter;

import de.polarnetworks.ft.plotter.PlotterInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SoftPlotter
implements PlotterInterface {
    Graphics2D graphics = null;
    BufferedImage bufferedImage = null;

    public SoftPlotter() {
        this.bufferedImage = new BufferedImage(680, 500, 2);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setBackground(Color.WHITE);
        this.graphics.setColor(Color.RED);
        this.graphics.drawRect(0, 0, 679, 499);
        this.graphics.setColor(Color.BLACK);
        this.graphics.translate(0.0, 500.0);
        this.graphics.scale(1.0, -1.0);
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public SoftPlotter(Graphics2D g) {
        this.graphics = g;
        this.graphics.setBackground(Color.WHITE);
        this.graphics.setColor(Color.BLACK);
        this.graphics.translate(0.0, 500.0);
        this.graphics.scale(1.0, -1.0);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    protected void setGraphics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    @Override
    public void drawCircle(double x, double y, int radiusX, int radiusY, int startAngle, int endAngle) {
        this.graphics.drawArc((int)x, (int)y, radiusX, radiusY, startAngle, endAngle);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, boolean penUpBeforeFirst) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawPolygon(int[] xCoords, int[] yCoords, Integer numberOfPoints, boolean penUpBeforeFirst) {
        this.graphics.drawPolygon(xCoords, yCoords, numberOfPoints);
    }

    @Override
    public void drawPolygon(int[] xCoords, int[] yCoords, Integer numberOfPoints) {
        this.graphics.drawPolygon(xCoords, yCoords, numberOfPoints);
    }

    @Override
    public void drawRectangle(int xmin, int ymin, int xmax, int ymax) {
        this.graphics.drawRect(xmin, ymin, xmax, ymax);
    }

    @Override
    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.drawLine(x2, y2, x3, y3);
        this.graphics.drawLine(x3, y3, x1, y1);
    }

    @Override
    public void forceStop() {
    }

    @Override
    public int getXPos() {
        return 0;
    }

    @Override
    public int getYPos() {
        return 0;
    }

    @Override
    public void initHome() {
    }

    @Override
    public void moveTo(int toX, int toY) {
    }

    @Override
    public void moveToOrigin() {
    }

    @Override
    public void penDown() {
        this.graphics.setColor(Color.BLACK);
    }

    @Override
    public void penUp() {
        this.graphics.setColor(Color.WHITE);
    }

    @Override
    public void setScale(int xmin, int xmax, int ymin, int ymax) {
    }

    public void getImage() throws IOException {
        File outputfile = new File("saved.png");
        ImageIO.write((RenderedImage)this.getBufferedImage(), "png", outputfile);
    }
}

