/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.plotter;

import de.polarnetworks.ft.FTObject;
import de.polarnetworks.ft.plotter.PlotterInterface;
import ftcomputing.robo.JavaFish;

public class FTPlotter
extends FTObject
implements PlotterInterface {
    private static int motsLLL = 21;
    private static int motsLLR = 37;
    private static int motsLRL = 25;
    private static int motsLRR = 41;
    private static int motsRLL = 22;
    private static int motsRLR = 38;
    private static int motsRRL = 26;
    private static int motsRRR = 42;
    private static int motsPEN = 64;
    private static int sleep = 14;
    private int xPos;
    private int yPos;
    private int pen = 0;
    private int xMax = 680;
    private int yMax = 500;
    private int XHome = 0;
    private int YHome = 0;
    private int XScale = 1;
    private int YScale = 1;
    private boolean enabled = true;

    public FTPlotter(int handle, JavaFish ft) {
        super(handle, ft);
    }

    @Override
    public void moveTo(int toX, int toY) {
        this.Strich((int)((double)(this.XHome + this.XScale * toX - this.xPos) + 0.5), (int)((double)(this.YHome + this.YScale * toY - this.yPos) + 0.5));
    }

    @Override
    public void moveToOrigin() {
        this.moveTo(0, 0);
    }

    @Override
    public void drawRectangle(int xmin, int ymin, int xmax, int ymax) {
        this.moveTo(xmin, ymin);
        this.penDown();
        this.moveTo(xmin, ymax);
        this.moveTo(xmax, ymax);
        this.moveTo(xmax, ymin);
        this.moveTo(xmin, ymin);
        this.penUp();
    }

    @Override
    public void drawCircle(double x, double y, int radiusX, int radiusY, int startAngle, int endAngle) {
        radiusX = Math.abs(radiusX);
        radiusY = Math.abs(radiusY);
        double xa = x;
        double ya = y;
        x = xa + (double)(radiusX * (int)Math.cos(Math.atan(1.0) * (double)startAngle / 45.0));
        y = ya + (double)(radiusY * (int)Math.sin(Math.atan(1.0) * (double)startAngle / 45.0));
        this.moveTo((int)x, (int)y);
        int ws = (int)Math.signum(endAngle - startAngle) * 800 / (radiusX * this.XScale + radiusY * this.YScale + 40);
        int w = startAngle;
        while (w <= endAngle) {
            x = xa + (double)radiusX * Math.cos(Math.atan(1.0) * (double)w / 45.0);
            y = ya + (double)radiusY * Math.sin(Math.atan(1.0) * (double)w / 45.0);
            if (this.pen == 0) {
                this.penDown();
            }
            this.moveTo((int)x, (int)y);
            w += ws;
        }
        x = xa + (double)radiusX * Math.cos(Math.atan(1.0) * (double)endAngle / 45.0);
        y = ya + (double)radiusY * Math.sin(Math.atan(1.0) * (double)endAngle / 45.0);
        this.moveTo((int)x, (int)y);
        this.penUp();
    }

    @Override
    public void setScale(int xmin, int xmax, int ymin, int ymax) {
        if (xmax < xmin && ymax < ymin) {
            throw new RuntimeException("Unusable values for new axis.");
        }
        this.XScale = xmax / (xmax - xmin);
        this.YScale = ymax / (ymax - ymin);
        this.XHome = -xmin * this.XScale;
        this.YHome = -ymin * this.YScale;
    }

    @Override
    public void initHome() {
        this.enabled = true;
        do {
            this.XMinusSchritt();
            this.YMinusSchritt();
        } while (this.ft.jrGetInput(this.iHandle, 7) == 1 && this.ft.jrGetInput(this.iHandle, 8) == 1 && this.isRun());
        do {
            this.XMinusSchritt();
        } while (this.ft.jrGetInput(this.iHandle, 7) == 1 && this.isRun());
        do {
            this.XPlusSchritt();
            JavaFish.sleep(sleep);
        } while (this.ft.jrGetInput(this.iHandle, 7) == 0 && this.isRun());
        do {
            this.YMinusSchritt();
            JavaFish.sleep(sleep);
        } while (this.ft.jrGetInput(this.iHandle, 8) == 1 && this.isRun());
        do {
            this.YPlusSchritt();
            JavaFish.sleep(sleep);
        } while (this.ft.jrGetInput(this.iHandle, 8) == 0 && this.isRun());
        this.YHome = 0;
        this.XHome = 0;
        this.xPos = 0;
        this.yPos = 0;
        this.ft.jrSetMotors(this.iHandle, 0);
    }

    private void Strich(int xr, int yr) {
        int dx = Math.abs(xr);
        int dy = Math.abs(yr);
        int nx = 0;
        int ny = 0;
        int d = 0;
        while ((nx != dx || ny != dy) && this.isRun()) {
            if (Math.abs(d + dy) < Math.abs(d + dy - dx)) {
                if (xr > 0) {
                    this.XPlusSchritt();
                } else {
                    this.XMinusSchritt();
                }
                ++nx;
                d += dy;
                continue;
            }
            if (Math.abs(d - dx) < Math.abs(d + dy - dx)) {
                if (yr > 0) {
                    this.YPlusSchritt();
                } else {
                    this.YMinusSchritt();
                }
                ++ny;
                d -= dx;
                continue;
            }
            if (xr > 0) {
                if (yr > 0) {
                    this.XpYpDiagonale();
                } else {
                    this.XpYmDiagonale();
                }
            } else if (yr > 0) {
                this.XmYpDiagonale();
            } else {
                this.XmYmDiagonale();
            }
            ++nx;
            ++ny;
            d = d + dy - dx;
        }
    }

    public void XMinusSchritt() {
        --this.xPos;
        this.ft.jrSetMotors(this.iHandle, motsRLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    public void XPlusSchritt() {
        ++this.xPos;
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    public void YPlusSchritt() {
        ++this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    public void YMinusSchritt() {
        --this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsRRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    private void XpYmDiagonale() {
        ++this.xPos;
        --this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsRRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    private void XpYpDiagonale() {
        ++this.xPos;
        ++this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRLL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    private void XmYpDiagonale() {
        --this.xPos;
        ++this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsRLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    private void XmYmDiagonale() {
        --this.xPos;
        --this.yPos;
        this.ft.jrSetMotors(this.iHandle, motsRLL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLLL + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsLRR + this.pen);
        JavaFish.sleep(sleep);
        this.ft.jrSetMotors(this.iHandle, motsRRR + this.pen);
        JavaFish.sleep(sleep);
    }

    @Override
    public void penDown() {
        if (this.enabled) {
            this.pen = motsPEN;
            this.ft.jrSetMotors(this.iHandle, this.pen);
            JavaFish.sleep(250);
        }
    }

    @Override
    public void penUp() {
        if (this.enabled) {
            this.pen = 0;
            JavaFish.sleep(100);
        }
    }

    @Override
    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.moveTo(x1, y1);
        this.penDown();
        this.moveTo(x2, y2);
        this.moveTo(x3, y3);
        this.moveTo(x1, y1);
        this.penUp();
    }

    @Override
    public void drawPolygon(int[] xCoords, int[] yCoords, Integer numberOfPoints) {
        this.drawPolygon(xCoords, yCoords, numberOfPoints, true);
    }

    @Override
    public void drawPolygon(int[] xCoords, int[] yCoords, Integer numberOfPoints, boolean penUpBeforeFirst) {
        if (xCoords == null || yCoords == null) {
            throw new IllegalArgumentException("Need to specify coordinates.");
        }
        if (penUpBeforeFirst) {
            this.penUp();
        }
        if (numberOfPoints == null) {
            numberOfPoints = xCoords.length;
        }
        int x0 = 0;
        int y0 = 0;
        int i = 0;
        while (i < numberOfPoints) {
            int x = xCoords[i];
            int y = yCoords[i];
            if (i == 0) {
                x0 = x;
                y0 = y;
                this.moveTo(x, y);
                this.penDown();
            } else {
                this.moveTo(x, y);
            }
            ++i;
        }
        this.moveTo(x0, y0);
        this.penUp();
    }

    @Override
    public int getXPos() {
        return this.xPos;
    }

    @Override
    public int getYPos() {
        return this.yPos;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine(x1, y1, x2, y2, true);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, boolean penUpBeforeFirst) {
        if (penUpBeforeFirst) {
            this.penUp();
        }
        this.moveTo(x1, y1);
        this.penDown();
        this.moveTo(x2, y2);
        this.penUp();
    }

    @Override
    public void forceStop() {
        this.penUp();
        this.enabled = false;
        this.ft.jrSetMotors(this.iHandle, 0);
    }

    public boolean isRun() {
        return this.enabled;
    }
}

