/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetworks.ft.calibration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Calibration {
    private String name;
    private Map<InputChannel, Set<CalibrationInfo>> inputs = new HashMap<InputChannel, Set<CalibrationInfo>>();

    public Calibration() {
    }

    public Calibration(String pathToFile) {
        this();
        try {
            SAXBuilder saxBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
            saxBuilder.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.parseFile(saxBuilder.build(new File(pathToFile)));
        }
        catch (JDOMException e) {
            throw new RuntimeException("Error reading calibrationfile. Incorrect structure?", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading calibrationfile.", e);
        }
    }

    public Calibration(InputStream in) {
        this();
        try {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            this.parseFile(saxBuilder.build(in));
        }
        catch (JDOMException e) {
            throw new RuntimeException("Error reading calibrationfile. Incorrect structure?", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading calibrationfile.", e);
        }
    }

    private void parseFile(Document doc) throws JDOMException, IOException {
        Element elCalibration = doc.getRootElement();
        String calName = elCalibration.getAttributeValue("name");
        if (StringUtils.isNotEmpty(calName)) {
            this.name = calName;
        }
        List elInputs = elCalibration.getChildren("input");
        for (Element elInput : elInputs) {
            String name = elInput.getAttributeValue("name");
            if (name != null) {
                name = name.toUpperCase();
                InputChannel channel = InputChannel.valueOf(name);
                this.inputs.put(channel, new HashSet());
                List elTags = elInput.getChildren("tag");
                for (Element elTag : elTags) {
                    int value = Integer.parseInt(elTag.getTextTrim());
                    this.inputs.get((Object)channel).add(new CalibrationInfo(elTag.getAttributeValue("name"), value));
                }
                continue;
            }
            throw new IllegalArgumentException("Name has to be specified for inputchannel in calibration file.");
        }
    }

    public void persist(String fileName) throws FileNotFoundException, IOException {
        Element root = new Element("calibration");
        root.addNamespaceDeclaration(Namespace.getNamespace("noNamespaceSchemaLocation", "http://www.polarnetworks.de/ft/schema/calibration.xsd"));
        Document doc = new Document(root);
        for (InputChannel channel : this.inputs.keySet()) {
            Element elInput = new Element("input");
            elInput.setAttribute("name", channel.name());
            Set<CalibrationInfo> infos = this.inputs.get((Object)channel);
            for (CalibrationInfo calibrationInfo : infos) {
                Element elTag = new Element("tag");
                elTag.setAttribute("name", calibrationInfo.getTag());
                elTag.setText(String.valueOf(calibrationInfo.getValue()));
                elInput.addContent(elTag);
            }
            root.addContent(elInput);
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        outputter.output(doc, (OutputStream)new FileOutputStream(file));
    }

    public int getValueForChannelAndTag(InputChannel channel, String tag) {
        for (CalibrationInfo info : this.inputs.get((Object)channel)) {
            if (info == null || !info.getTag().equals(tag)) continue;
            return info.getValue();
        }
        return -1;
    }

    public void addCalibrationInfo(InputChannel channel, String tag, int value) {
        Set<CalibrationInfo> infoSet = this.inputs.get((Object)channel);
        if (infoSet == null) {
            infoSet = new HashSet<CalibrationInfo>();
            this.inputs.put(channel, infoSet);
        }
        infoSet.add(new CalibrationInfo(tag, value));
    }

    public String getName() {
        return this.name;
    }

    class CalibrationInfo {
        private String tag;
        private int value;

        CalibrationInfo(String pTag, int pValue) {
            this.tag = pTag;
            this.value = pValue;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static enum InputChannel {
        EX,
        EY,
        E1,
        E2,
        E3,
        E4,
        E5,
        E6,
        E7,
        E8;

    }
}

