/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetwork.polarfish.plotter.gui.menu;

import de.polarnetwork.polarfish.plotter.gui.MainFrame;
import de.polarnetwork.polarfish.plotter.gui.actions.ClearPreviewAction;
import de.polarnetwork.polarfish.plotter.gui.actions.InitHomeAction;
import de.polarnetwork.polarfish.plotter.gui.actions.PlotOnPaperAction;
import de.polarnetwork.polarfish.plotter.gui.actions.StopPlotterAction;
import de.polarnetwork.polarfish.plotter.gui.actions.SwitchModelAction;
import de.polarnetwork.polarfish.plotter.gui.actions.plots.Lindenmayer2Action;
import de.polarnetwork.polarfish.plotter.gui.actions.plots.LindenmayerAction;
import de.polarnetwork.polarfish.plotter.gui.actions.plots.SierpinskiAction;
import de.polarnetwork.polarfish.plotter.gui.actions.plots.SnowflakeAction;
import de.polarnetwork.polarfish.plotter.gui.listeners.ExitListener;
import de.polarnetwork.polarfish.plotter.gui.menu.IconFactory;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class PolarFishMenuBar
extends JMenuBar {
    private MainFrame mainFrame = null;
    private InitHomeAction initHomeAction = null;
    private SierpinskiAction sierpinskiAction = null;
    private SnowflakeAction snowflakeAction = null;
    private LindenmayerAction lindenmayerAction = null;
    private Lindenmayer2Action lindenmayer2Action = null;
    private PlotOnPaperAction plotOnPaperAction = null;
    JMenu plotterMenu = null;
    JToolBar buttonMenu = null;
    private StopPlotterAction stopPlotterAction;
    private ClearPreviewAction clearPreviewAction;
    private static final long serialVersionUID = 7650570475465850913L;

    protected JMenu getPlotterMenu() {
        return this.plotterMenu;
    }

    public PolarFishMenuBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.plotOnPaperAction = new PlotOnPaperAction(mainFrame, "Plot", IconFactory.getInstance().getPrintIcon());
        this.stopPlotterAction = new StopPlotterAction(mainFrame, "Stop Plotter", IconFactory.getInstance().getStopIcon());
        this.initHomeAction = new InitHomeAction(mainFrame, "Init Home", IconFactory.getInstance().getHomeIcon());
        this.sierpinskiAction = new SierpinskiAction(mainFrame, "Sierpinksi Triangle", null);
        this.snowflakeAction = new SnowflakeAction(mainFrame, "Snoflake", null);
        this.lindenmayerAction = new LindenmayerAction(mainFrame, "Lindenmayer", null);
        this.lindenmayer2Action = new Lindenmayer2Action(mainFrame, "Lindenmayer2", null);
        this.clearPreviewAction = new ClearPreviewAction(mainFrame, "Clear Preview", IconFactory.getInstance().geTrashIcon());
        this.createMenu();
    }

    private void createMenu() {
        this.createMainMenu();
        this.buttonMenu = new JToolBar(0);
        this.buttonMenu.setEnabled(true);
        this.buttonMenu.setVisible(true);
        this.buttonMenu.setFloatable(false);
        this.buttonMenu.setBorder(BorderFactory.createRaisedBevelBorder());
        this.buttonMenu.setSize(400, 30);
        this.mainFrame.getContentPane().add((Component)this.buttonMenu, "North");
        this.createPlotterMenu();
        this.createHelpMenu();
        this.mainFrame.validate();
        this.mainFrame.repaint();
        this.mainFrame.pack();
    }

    private void createMainMenu() {
        JMenu menu = new JMenu("Main");
        this.add(menu);
        menu.add(new SwitchModelAction(this.mainFrame, "Choose Model", null, false));
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ExitListener());
        menu.add(exitItem);
    }

    private void createPlotterMenu() {
        this.plotterMenu = new JMenu("Plotter");
        this.add(this.plotterMenu);
        this.plotterMenu.add(this.initHomeAction);
        this.buttonMenu.add(this.initHomeAction);
        this.plotterMenu.add(this.clearPreviewAction);
        this.buttonMenu.add(this.clearPreviewAction);
        this.plotterMenu.addSeparator();
        JMenu predefinedPlotsMenu = new JMenu("Predefined Plots");
        predefinedPlotsMenu.add(this.sierpinskiAction);
        predefinedPlotsMenu.add(this.snowflakeAction);
        predefinedPlotsMenu.add(this.lindenmayerAction);
        predefinedPlotsMenu.add(this.lindenmayer2Action);
        this.plotterMenu.add(predefinedPlotsMenu);
        this.plotterMenu.addSeparator();
        this.buttonMenu.add(this.plotOnPaperAction);
        this.plotterMenu.add(this.plotOnPaperAction);
        this.buttonMenu.add(this.stopPlotterAction);
        this.plotterMenu.add(this.stopPlotterAction);
    }

    private void createHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setAlignmentX(1.0f);
        this.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem("About");
        JMenuItem dokuItem = new JMenuItem("Documentation");
        helpMenu.add(aboutItem);
        helpMenu.add(dokuItem);
    }

    public void disablePlotterActions() {
        this.initHomeAction.setEnabled(false);
        this.plotOnPaperAction.setEnabled(false);
    }

    public void enablePlotterActions() {
        this.initHomeAction.setEnabled(true);
        this.plotOnPaperAction.setEnabled(true);
    }

    public InitHomeAction getInitHomeAction() {
        return this.initHomeAction;
    }

    public SierpinskiAction getSierpinskiAction() {
        return this.sierpinskiAction;
    }

    public SnowflakeAction getSnowflakeAction() {
        return this.snowflakeAction;
    }

    public PlotOnPaperAction getPlotOnPaperAction() {
        return this.plotOnPaperAction;
    }

    public JToolBar getButtonMenu() {
        return this.buttonMenu;
    }
}

