/*
 * Decompiled with CFR 0.152.
 */
package de.polarnetwork.polarfish.plotter.gui;

import de.polarnetwork.polarfish.plotter.gui.ImagePanel;
import de.polarnetwork.polarfish.plotter.gui.menu.PolarFishMenuBar;
import de.polarnetwork.polarfish.supportedModels.SupportedModelDecriptor;
import de.polarnetworks.ft.plotter.PlotterFactory;
import de.polarnetworks.ft.plotter.SoftPlotter;
import de.polarnetworks.ft.plotter.predefinedPlots.Plottable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -6954480806054157885L;
    private PolarFishMenuBar polarfishMenu = null;
    private JPanel previewPanel = new JPanel();
    private SupportedModelDecriptor currentModel = null;
    private Plottable currentPlottable;
    private boolean workerBusy = false;

    public MainFrame() {
        this.previewPanel.setLayout(new BorderLayout(30, 0));
        this.previewPanel.setBackground(Color.WHITE);
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().add((Component)this.previewPanel, "Center");
        this.polarfishMenu = new PolarFishMenuBar(this);
        this.setJMenuBar(this.polarfishMenu);
        this.setTitle("PolarFish");
        this.setPreferredSize(new Dimension(800, 580));
        this.setSize(800, 5800);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setBackground(Color.WHITE);
        Toolkit toolkit = this.getToolkit();
        Dimension size = toolkit.getScreenSize();
        this.setLocation(size.width / 2 - this.getWidth() / 2, size.height / 2 - this.getHeight() / 2);
        this.getContentPane().setLayout(new BorderLayout(30, 0));
        this.getPolarfishMenu().getPlotOnPaperAction().setEnabled(false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.pack();
    }

    protected SupportedModelDecriptor getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(SupportedModelDecriptor currentModel) {
        this.currentModel = currentModel;
    }

    public void drawPreview(Plottable plottable) {
        this.currentPlottable = plottable;
        if (this.currentPlottable != null) {
            if (!this.isWorkerBusy()) {
                this.getPolarfishMenu().getPlotOnPaperAction().setEnabled(true);
            }
            SoftPlotter softPlotter = (SoftPlotter)PlotterFactory.getInstance().getSoftPlotter();
            plottable.setPlotter(softPlotter);
            plottable.plot();
            ImagePanel imagePanel = new ImagePanel(softPlotter.getBufferedImage());
            this.previewPanel.removeAll();
            this.previewPanel.add(imagePanel);
            this.previewPanel.setEnabled(true);
            this.pack();
        }
    }

    public void clearPreviewPanel() {
        this.getPolarfishMenu().getPlotOnPaperAction().setEnabled(false);
        this.getPreviewPanel().removeAll();
        this.getPreviewPanel().validate();
        this.repaint();
        this.pack();
    }

    protected JPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public Plottable getCurrentPlottable() {
        return this.currentPlottable;
    }

    public static void main(String[] arguments) {
        MainFrame myFrame = new MainFrame();
        myFrame.setVisible(true);
        myFrame.pack();
    }

    public PolarFishMenuBar getPolarfishMenu() {
        return this.polarfishMenu;
    }

    public boolean isWorkerBusy() {
        return this.workerBusy;
    }

    public void setWorkerBusy(boolean workerBusy) {
        this.workerBusy = workerBusy;
    }
}

