/**
 * Arduino-Sketch for control of a piston actuated lever 
 * with a FESTO MYPE proportional valve
 * 
 * V_valve: 20-24V
 * V_contorl: 0-10V
 * 
 * 8-Bit DAC Ferranti ZN425 (A8-A15)
 * + Opamp LM 358, noninverting Amp. R2=2k2, R1=1k
 * 
 * Mag. Position sensor: Grove AS5600
 * 
 */


#include "AS5600.h"
#include <AFMotor.h>

//#include <Wire.h>
#include <Adafruit_VL53L0X.h>

//VL53L0X sensor;

Adafruit_VL53L0X sensor = Adafruit_VL53L0X();

String cmd;
int state=0;
int dialstate=0;
long i=0;
float d=0.0, d_soll=510;
float vd,d_old=0.0;
float t,t_old=0.0;
#define MAXPEAKS 50
float peakIntervals[MAXPEAKS];
unsigned long lastPeakTime=0;

int u;
int rc_control= 0;

int control_on=1;
float avgPeriod=0.0;
int peakCount=0;
int rising=0;
int valve_speed=255;


//#define RC_CONTROL

#ifdef TM1637DISPLAY

#include "TM1637Display.h"

#define CLK 22 //pins definitions for TM1637 and can be changed to other ports
#define DIO 24
TM1637Display  tm1637(CLK, DIO);
void setupTm637() {
  // put your setup code here, to run once:

  pinMode(A0,INPUT);
  pinMode(7,INPUT_PULLUP);
 
  //tm1637.set();
  //tm1637.init();
}

#define SW 26
#define DT 28
#define CK 30
#endif

#include <Servo.h>
Servo servo;
AF_DCMotor m1(1,MOTOR12_2KHZ); // Winde für Arm A
AF_DCMotor m2(2,MOTOR12_2KHZ); // Schneckenantrieb Arm B
AF_DCMotor m3(3,MOTOR12_2KHZ); // Drehteller
 
AF_DCMotor  mot[3]   = {  m1,m2,m3};

volatile long enc_count = 0;
  

#define AD0 36
#define AD1 38

#define SH 40

/**
 * Ventil 25: A
 * Ventil 22: B
 */

void setupISR() {
  

  pinMode(50, INPUT);
  pinMode(51, INPUT);

  // Aktiviert Pin-Change Interrupt für Port B
  PCICR |= (1 << PCIE0);     // Enable PCINT0 interrupt (Port B)
  PCMSK0 |= (1 << PCINT3);   // Pin 50 (PB3)
  PCMSK0 |= (1 << PCINT2);   // Pin 51 (PB2)
}
volatile bool pin50Changed = false;
volatile bool pin51Changed = false;


ISR(PCINT0_vect) {
  // Statusvergleich von Port B
 static uint8_t tmp=0;
 static int8_t lookup_table[] = {0,-1,1,0,1,0,0,-1,-1,0,0,1,0,1,-1,0};
    static uint8_t enc_val = 0;
  static uint8_t lastPortB = PINB;
  uint8_t currentPortB = PINB;
// PB2 = 4, PB3=8

  if ((currentPortB ^ lastPortB) & (1 << PB3)) {
    pin50Changed = true; 
    tmp = ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
 //   Serial.print("A");
  }
 

  if ((currentPortB ^ lastPortB) & (1 << PB2)) {
    pin51Changed = true;
  //   Serial.print("B"); 
   tmp =   ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
  }
  
        
        enc_val = enc_val << 2;
        enc_val = enc_val | tmp;
     Serial.println(enc_val & 0b1111);
        enc_count = enc_count + lookup_table[enc_val & 0b1111];
  lastPortB = currentPortB;
}

    
#include <PID_v1_bc.h>

double  sinput, soutput , ssetpoint ;
int l_slimit=-127; int u_slimit=127; 
double kp=.1,ki=0.5, kd=0.00;
PID servoPID = PID (&sinput, &soutput, &ssetpoint, kp,ki,kd, DIRECT); //0.55 20 0.0036


#include "PID_AutoTune_v0.h"
PID_ATune aTune(&sinput, &soutput);
double aTuneStep=10, aTuneNoise=5, aTuneStartValue=20;
unsigned int aTuneLookBack=20;
byte ATuneModeRemember=2;
bool tuning=true;
  
/**
 * i2C-Weiche:
 */
#define TCAADDR 0x70
void tcascanner()
{
  Serial.println("\nTCAScanner ready!");
    
    for (uint8_t t=0; t<8; t++) {
      tcaselect(t);
      Serial.print("TCA Port #"); Serial.println(t);

      for (uint8_t addr = 0; addr<=127; addr++) {
        if (addr == TCAADDR) continue;

        Wire.beginTransmission(addr);
        if (!Wire.endTransmission()) {
          Serial.print("Found I2C 0x");  Serial.println(addr,HEX);
        }
      }
    }
    Serial.println("\ndone");
}

/**
 * i2C-Kanal einstellen
 */
void tcaselect(uint8_t i) {
  if (i > 7) return;
 
  Wire.beginTransmission(TCAADDR);
  Wire.write(1 << i);
  Wire.endTransmission();  
}

void readM62320()
{
  tcaselect(4);
   Wire.beginTransmission(0x38);
  Wire.write(0x00);
  Wire.requestFrom(0x38,1);
  byte data = Wire.read();
  Serial.print(" "); Serial.print(data);  Serial.print(" ");
  Wire.endTransmission(); 
}

AS5600 encoder;

long time0;


void setup() {
  Serial.begin(115200);
  tcascanner();
  servoPID.SetMode(AUTOMATIC);   //set PID in Auto mode
  servoPID.SetSampleTime(1);  // refresh rate of PID controller
  servoPID.SetOutputLimits(l_slimit,u_slimit); // drehventil this is the MAX PWM value to move motor, here change in value reflect change in speed of motor.

  tcaselect(0);
  d_soll=ssetpoint=4096-encoder.getRawAngle(); // Startwert = Aktueller Wert
  
//setupISR();
  if(tuning)
  {
    tuning=false;
  //  changeAutoTune();
    tuning=true;
  
  }
 #ifdef TM1637DISPLAY 
   setupTm637();

  pinMode(CK, INPUT_PULLUP);
  pinMode(DT,INPUT_PULLUP);
  pinMode(SW,INPUT_PULLUP);
#endif
  pinMode(2,INPUT);

  Serial.println("DAC - ZN425");
  // put your setup code here, to run once:
  pinMode(A8,OUTPUT);
  pinMode(A9,OUTPUT);
  pinMode(A10,OUTPUT);
  pinMode(A11,OUTPUT);
  pinMode(A12,OUTPUT);
  pinMode(A13,OUTPUT);
  pinMode(A14,OUTPUT);
  pinMode(A15,OUTPUT);
  pinMode(AD0,OUTPUT);
  pinMode(AD1,OUTPUT);
  digitalWrite(AD0,LOW);
  pinMode(SH,OUTPUT);
  digitalWrite(SH,LOW);
  digitalWrite(AD1,LOW);

  
  
  tcaselect(3);
  delay(10);
  Wire.begin(); 
  Serial.println("initializing VL53L0X ");
//  sensor.setTimeout(50);

//3L0X::begin(uint8_t i2c_addr, boolean debug, TwoWire *i2c,
 //                               VL53L0X_Sense_config_t vl_config) {
  if (!sensor.begin(0x29,true))
  {
    Serial.println("Failed to detect and initialize sensor!");
    //while (1) {}
  }

  
   Serial.println("done");
   tcaselect(0);


}


void DAC_sel(int adr)
{
  switch(adr)
  {
    case 0: digitalWrite(AD0,LOW);digitalWrite(AD1,LOW); break;
    case 1: digitalWrite(AD0,HIGH);digitalWrite(AD1,LOW); break;
    case 2: digitalWrite(AD0,LOW);digitalWrite(AD1,HIGH); break;
    case 3: digitalWrite(AD0,HIGH);digitalWrite(AD1,HIGH); break;
  }
 //  delay(150);
}

void DAC_out(byte val)
{
  if(val & 0x01) digitalWrite(A8,HIGH); else digitalWrite(A8,LOW);
  if(val & 0x02) digitalWrite(A9,HIGH); else digitalWrite(A9,LOW);
  if(val & 0x04) digitalWrite(A10,HIGH); else digitalWrite(A10,LOW);
  if(val & 0x08) digitalWrite(A11,HIGH); else digitalWrite(A11,LOW);
  if(val & 0x10) digitalWrite(A12,HIGH); else digitalWrite(A12,LOW);
  if(val & 0x20) digitalWrite(A13,HIGH); else digitalWrite(A13,LOW);
  if(val & 0x40) digitalWrite(A14,HIGH); else digitalWrite(A14,LOW);
  if(val & 0x80) digitalWrite(A15,HIGH); else digitalWrite(A15,LOW);
 
      // delay(150);  
}
void festo_out(float v, int val)
{
  val= -val;
  if(val>0) // upwards
  {
    val=val+132; //135;
  }
  else
  {
    val *= 0.5;
    val=val+158; //155;
  }
  //Serial.println(val);
  DAC_out(val);
}

void loop() {
  char buf[128];
  char * ptr;
  // put your main code here, to run repeatedly:
  float draw=0.0;
  tcaselect(0);  
  draw = 4096-encoder.getRawAngle();  //analogRead(A14);
  d=draw;
  VL53L0X_RangingMeasurementData_t measure;
  //d= d*0.2 + 0.8* draw;
  
#ifdef OSCILLATION_MEASUREMENT 

  if( d> d_old+1 && ! rising) rising=true;
  else if( d < d_old-1 && rising)
  {
    rising=false;
    unsigned long now=millis();
    
    if(lastPeakTime > 0 && peakCount<MAXPEAKS)
    {
      peakIntervals[peakCount++]=now -lastPeakTime;
    }
    
    lastPeakTime=now;
    Serial.print("PEAK at ");
    Serial.print(now);
    Serial.print(" ms, Position: ");
    Serial.println(d);
  }
   // If enough peaks collected, compute average period
  
  if (peakCount == MAXPEAKS) {
    unsigned long sum = 0;
    for (int i = 0; i < MAXPEAKS; i++) {
      sum += peakIntervals[i];
    }
    avgPeriod = sum / (float)MAXPEAKS;
    Serial.print("AVG_PERIOD ");
    Serial.print(avgPeriod);
    Serial.println(" ms");
    peakCount = 0; // reset for next measurement
    delay(3000);
  }
  
 #endif
  
  t=millis();
  vd=(d-d_old)/(t-t_old);
  d_old=d; t_old=t;
  
  

  while (Serial.available()) { //Check if the serial data is available.
    delay(3);                  // a small delay
    char c = Serial.read();  // storing input data
    cmd += c;         // accumulate each of the characters in readString
  }
  if (cmd.length() >0 ) {
     cmd.toCharArray(buf, 100);
     if(cmd.startsWith("RC")) {
      rc_control= 1-rc_control;
      Serial.print("RC Control ");
      if(rc_control)
      Serial.println("ON");
      else
      Serial.println("OFF");

      control_on=1;

    }
    if(cmd.startsWith("TO")) {
      d_soll = atof(buf+3);
      control_on=1;
    }
    
   
    
    
    if(cmd.startsWith("K?")) {
      Serial.print("KP=");
      Serial.print(kp);
      Serial.print(" KI=");
      Serial.print(ki);
      Serial.print(" KD=");
      Serial.println(kd,5);

      delay(1000);
      control_on=1;
    }
     if(cmd.startsWith("KP")) {
      kp = atof(buf+3);
      servoPID.SetTunings(kp,ki,kd);
      control_on=1;
    }
    if(cmd.startsWith("KI")) {
      ki = atof(buf+3);
      servoPID.SetTunings(kp,ki,kd);
      control_on=1;

    }
     if(cmd.startsWith("KD")) {
      kd = atof(buf+3);
      servoPID.SetTunings(kp,ki,kd);
      control_on=1;

    }
     if(cmd.startsWith("SPEED")) {
      int v;
      v = atoi(buf+5);
      Serial.print("SPEED ");
      Serial.println(v);
      valve_speed=v;
     }
     if(cmd.startsWith("UP")) {
        Serial.println("UP");
        DAC_out(0);
        control_on=0;
     }
     if(cmd.startsWith("DN")) {
        Serial.println("DN");
        DAC_out(255);
        control_on=0;
     }
      
     if(cmd.startsWith("DAC")) {
        Serial.print("DAC ");
        ptr = strtok(buf+3, ",");
        int val =atoi(ptr);
        Serial.println(val);
        DAC_out(val);
        control_on=0;
        delay(1000);
    }
    
    if(cmd.startsWith("OFF")) {
      state=1-state;      
      control_on=0;
      time0=millis();      
    }
    cmd="";
    }

#ifdef RC_CONTROL
 // RC Control
  int val = pulseIn(2, HIGH);
  int mval=map(val,900,2000,2200,2600); 
  Serial.print(val); 
  if(rc_control)  d_soll=mval;
  Serial.print(" ");
#endif  
 
  Serial.print(d_soll); 


  Serial.print(", ");
  Serial.print(d); 
 

  sinput=d; //enc_count;
  ssetpoint = d_soll;
 #ifdef SMC
   soutput = calculate_SMC(d,d_old);
 #else
 tuning=false;
 if(tuning)
   {
    byte val = (aTune.Runtime());
    if (val!=0)
    {
      tuning = false;
    }
    if(!tuning)
    { //we're done, set the tuning parameters
      kp = aTune.GetKp();
      ki = aTune.GetKi();
      kd = aTune.GetKd();
      servoPID.SetTunings(kp,ki,kd);
      //AutoTuneHelper(false);
    }
  }
  else
  {
    
    servoPID.Compute();
  }
 #endif

#ifdef TM1637DISPLAY
  if(!digitalRead(SW))
  {
      if(dialstate==0) dialstate=1;
      else if(dialstate==1) 
  {
    dialstate=0;
    d_soll=enc_count;
  }
  }
  else 

  if(dialstate==0)
    enc_count= (int) d;
#endif
  
  d_old=d;
 

#ifdef TM1637DISPLAY 
/* Timing von tm1637 verhundst PID-REgelung */
  if(dialstate==0)
   {
     //tm1637.displayNum((int) d);
     tm1637.showNumberDec((int) d, false,4,0);
     tm1637.setBrightness(0x0f,true); 
   }
   else
   {
     //tm1637.displayNum((int) enc_count);
     tm1637.showNumberDecEx((int) enc_count,64,false,4,0);
     tm1637.setBrightness(1,true); 
   }
#endif

 Serial.print(" ");
 Serial.print(soutput);

if(control_on)
  //servo.write(soutput);
  {

  festo_out(d-d_old,soutput);
 
  }
  // Serial.print(" ");
     tcaselect(3);
     delay(1);  Serial.print(" ");
     sensor.rangingTest(&measure, false); // pass in 'true' to get debug data printout!
      Serial.print(measure.RangeMilliMeter);

      readM62320();
    tcaselect(0);
  Serial.println();
}

void changeAutoTune()
{
 if(!tuning)
  {
    //Set the output to the desired starting frequency.
    soutput=aTuneStartValue;
    aTune.SetNoiseBand(aTuneNoise);
    aTune.SetOutputStep(aTuneStep);
    aTune.SetLookbackSec((int)aTuneLookBack);
    AutoTuneHelper(true);
    tuning = true;
  }
  else
  { //cancel autotune
    aTune.Cancel();
    tuning = false;
    AutoTuneHelper(false);
  }
}

void AutoTuneHelper(boolean start)
{
  if(start)
    ATuneModeRemember = servoPID.GetMode();
  else
   servoPID.SetMode(ATuneModeRemember);
}

/**
 * PWM-Wert out für Motor i ausgeben
 */
void pwmOut(int i,int out) {            
    if (out > 0) {                  
      mot[i].run(FORWARD); mot[i].setSpeed(out); 
    }
    else {
      mot[i].run(BACKWARD); mot[i].setSpeed(abs(out)); 
    } 
}
