

#include "AS5600.h"
#include <AFMotor.h>
#include <Servo.h>
Servo servo;
AF_DCMotor m1(1,MOTOR12_2KHZ); // Winde für Arm A
AF_DCMotor m2(2,MOTOR12_2KHZ); // Schneckenantrieb Arm B
AF_DCMotor m3(3,MOTOR12_2KHZ); // Drehteller
 
AF_DCMotor  mot[3]   = {  m1,m2,m3};

    volatile long enc_count = 0;

#define VALVE_A 32
#define VALVE_B 33

  


void setupISR() {
  //pinMode(50, INPUT);
  //pinMode(51, INPUT);

  // Aktiviert Pin-Change Interrupt für Port B
  PCICR |= (1 << PCIE0);     // Enable PCINT0 interrupt (Port B)
  PCMSK0 |= (1 << PCINT3);   // Pin 50 (PB3)
  PCMSK0 |= (1 << PCINT2);   // Pin 51 (PB2)
}
volatile bool pin50Changed = false;
volatile bool pin51Changed = false;


ISR(PCINT0_vect) {
  // Statusvergleich von Port B
 static uint8_t tmp=0;
 static int8_t lookup_table[] = {0,-1,1,0,1,0,0,-1,-1,0,0,1,0,1,-1,0};
    static uint8_t enc_val = 0;
  static uint8_t lastPortB = PINB;
  uint8_t currentPortB = PINB;
// PB2 = 4, PB3=8

  if ((currentPortB ^ lastPortB) & (1 << PB3)) {
    pin50Changed = true; 
    tmp = ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
 //   Serial.print("A");
  }
 

  if ((currentPortB ^ lastPortB) & (1 << PB2)) {
    pin51Changed = true;
  //   Serial.print("B"); 
   tmp =   ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
  }
  
        
        enc_val = enc_val << 2;
        enc_val = enc_val | tmp;
     Serial.println(enc_val & 0b1111);
        enc_count = enc_count + lookup_table[enc_val & 0b1111];
  lastPortB = currentPortB;
}

    
#include <PID_v1_bc.h>
double kp = 10, ki = .01, kd = .01; //0.01; 
//int ulimit_l= 70;int ulimit_u=130;
int ulimit_l= 0;int ulimit_u=255;
double input1Old, input, output , setpoint ;
//PID myPID = PID (&input, &output, &setpoint, .2, 4.5, 0.0, DIRECT);
//PID myPID = PID (&input, &output, &setpoint, 0.05, 4.5, 0.001, DIRECT);
PID myPID = PID (&input, &output, &setpoint, 3, .0, 0.0, DIRECT);
double  sinput, soutput , ssetpoint ;
PID servoPID = PID (&sinput, &soutput, &ssetpoint, 8, 5.0, 0.0, DIRECT);

/**
 * i2C-Weiche:
 */
#define TCAADDR 0x70
void tcascanner()
{
  Serial.println("\nTCAScanner ready!");
    
    for (uint8_t t=0; t<8; t++) {
      tcaselect(t);
      Serial.print("TCA Port #"); Serial.println(t);

      for (uint8_t addr = 0; addr<=127; addr++) {
        if (addr == TCAADDR) continue;

        Wire.beginTransmission(addr);
        if (!Wire.endTransmission()) {
          Serial.print("Found I2C 0x");  Serial.println(addr,HEX);
        }
      }
    }
    Serial.println("\ndone");
}

/**
 * i2C-Kanal einstellen
 */
void tcaselect(uint8_t i) {
  if (i > 7) return;
 
  Wire.beginTransmission(TCAADDR);
  Wire.write(1 << i);
  Wire.endTransmission();  
}

AS5600 encoder;

long time0;

void setup() {
  Serial.begin(115200);
    tcascanner();
  // put your setup code here, to run once:
  pinMode(VALVE_A,OUTPUT);
  //digitalWrite(44,LOW);
   pinMode(VALVE_B,OUTPUT);
       digitalWrite(VALVE_A,HIGH);
    digitalWrite(VALVE_B,HIGH);
  //digitalWrite(42,LOW);
    /**
   * Aktiviere Greifer-Servo
   */
  pinMode(9,OUTPUT);

  servo.attach(9);
  servo.write(100);
  
      myPID.SetMode(AUTOMATIC);   //set PID in Auto mode
    myPID.SetSampleTime(1);  // refresh rate of PID controller
    myPID.SetOutputLimits(ulimit_l, ulimit_u); // this is the MAX PWM value to move motor, here change in value reflect change in speed of motor.
    servoPID.SetMode(AUTOMATIC);   //set PID in Auto mode
    servoPID.SetSampleTime(1);  // refresh rate of PID controller
    servoPID.SetOutputLimits(10, 120); // this is the MAX PWM value to move motor, here change in value reflect change in speed of motor.

   tcaselect(0);
   setpoint=encoder.getRawAngle(); // Startwert = Aktueller Wert
//setupISR();



}
String cmd;
int state=0;

long i=0;
float d=0.0, d_soll=510;
int u;
void loop() {
  char buf[128];
  char * ptr;
  // put your main code here, to run repeatedly:
  float x=0.0;
  for(int i=0; i<10;i++)
  {
   tcaselect(0);
    
   x += 4096-encoder.getRawAngle();  //analogRead(A14);
   //delay(1);
  }
  d=x/10;
 

  while (Serial.available()) { //Check if the serial data is available.
    delay(3);                  // a small delay
    char c = Serial.read();  // storing input data
    cmd += c;         // accumulate each of the characters in readString
  }
  if (cmd.length() >0 ) {
    cmd.toCharArray(buf, 100);
    
    if(cmd.startsWith("TO")) {
      d_soll = atof(buf+3);
      state=1;
    }
    if(cmd.startsWith("OFF")) {
      state=0;
      time0=millis();
      digitalWrite(VALVE_A,LOW);
        Serial.println("VALVE A: Low");
        digitalWrite(VALVE_B,LOW);
        Serial.println("VALVE B: Low");      
    }
     if(cmd.startsWith("S")) {
      ptr = strtok(buf+2, ",");
      int s =atoi(ptr);
      servo.write(s);
    //  delay(200);
    //  servo.write(95);
    }
    if(cmd.startsWith("A")) {
       if( atoi(buf+1) ==1)
       {
        digitalWrite(VALVE_A,HIGH);
        Serial.println("VALVE A: High");
       }
       else
       {
        digitalWrite(VALVE_A,LOW);
        Serial.println("VALVE A: Low");
       }
      state=0;
    }
    if(cmd.startsWith("B")) {
      if( atoi(buf+1) ==1)
       {
        digitalWrite(VALVE_B,HIGH);
        Serial.println("VALVE A: High");
       }
       else
       {
        digitalWrite(VALVE_B,LOW);
        Serial.println("VALVE A: Low");
       }
      state=0;
    }
    if(cmd.startsWith("UP")) {
      
        digitalWrite(VALVE_A,HIGH);
      
        digitalWrite(VALVE_B,LOW);
        Serial.println("UP"); state=0;
       }
        if(cmd.startsWith("DN")) {
      
        digitalWrite(VALVE_B,HIGH);
      
        digitalWrite(VALVE_A,LOW);
        Serial.println("DN"); state=0;
       }
    
    cmd="";
    }
if(state!=0)
if( (millis() - time0) % 1 == 0)
{
  state=2;
}
else
state=1;
 input=d;
  setpoint=d_soll;
if (state==2) {
  //Serial.print(" T:");
  Serial.print(millis() -time0);
  Serial.print(", ");
  Serial.print(enc_count);
    Serial.print(", ");
  //Serial.print(" SOLL:");
  Serial.print(d_soll); 
 
  Serial.print(", ");
  //Serial.print("IST:"); 
  Serial.print(d);
}
  if(state>0)
  {

  if( abs(d-d_soll) < 4)
  {
    digitalWrite(VALVE_A,HIGH);
    digitalWrite(VALVE_B,HIGH);
    //Serial.print(", ");
   // Serial.print("U:"); 
   // Serial.print(0);
   // Serial.print(" D:0");
  }
  else if( d < d_soll )
  {
    digitalWrite(VALVE_A,HIGH);
    digitalWrite(VALVE_B,LOW);

    u=abs(d-d_soll) /2 ;
    //if(u<50) u=50;
    //?
    delay(u);
    
    //Serial.print(", ");
    //Serial.print("U:"); 
    //Serial.print(u);
    //Serial.print(" D:-1");
        //digitalWrite(VALVE_B,HIGH);
  }
  else
  {
    digitalWrite(VALVE_A,LOW);
    digitalWrite(VALVE_B,HIGH);
    
  u=3*abs(d-d_soll) /2 ;
  // if(u<20) u=30;
   
    //?delay(u);
   // digitalWrite(42,LOW);
    //Serial.print(", ");
    //Serial.print("U:"); 
    //Serial.print(u);
    //Serial.print(" D:+1");
    
         //  digitalWrite(VALVE_A,HIGH);
  }

  }
/*
  myPID.Compute();

  sinput=enc_count;
  ssetpoint = d_soll;
  servoPID.Compute();
  
  pwmOut(1,soutput);
  */
  if(state==2) Serial.println();
}

/**
 * PWM-Wert out für Motor i ausgeben
 */
void pwmOut(int i,int out) {            
    if (out > 0) {                  
      mot[i].run(FORWARD); mot[i].setSpeed(out); 
    }
    else {
      mot[i].run(BACKWARD); mot[i].setSpeed(abs(out)); 
    } 
}
